//
// XBlast Robot File
//
//
// Program XBLAST V2.6 or higher
// (C) by Immanuel Halupczok <xblast@karimmi.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#include "localframes.inc"

/*
  Parameter an den Wusel:
    playerDamaged
    bodyAngle
    FrontWind

    playerLocation: End-Verschiebung auf dem Boden
    playerAngle: End-Drehung auf dem Boden

    playerHeight: Abstand Boden-Wuselmitte
*/


#declare haare_schnell = 0;
#declare haare_anz = 400; // 2000;

// Wird von XBlastTexture bentigt:
#declare playerIsSick = 0;

#include "XBlastTexture.inc"
#include "transforms.inc"



#declare epsi = 0.0001;
#declare armdicke = 0.15;
#declare beindicke = 0.15;
#declare RR = seed(0);
#declare RRD = seed(1); // Zusatz-Random fr damage




/* Gute Werte fr kruemmung: 1 fr normal, 3 fr damaged */
#macro haar(laenge, kruemmung, wind)
  #local endpunkt = vnormalize(<laenge, 0, 0> + wind) * laenge;
  #if (haare_schnell)
    cylinder {
      <0, 0, 0> endpunkt 0.03
      texture {helmetTexture}
    }
  #else  
    #local lyz = kruemmung * laenge * 0;

    /* Hinweis: Bei cubic_spline sollten die Tangenten 6 mal so lang
       sein, wie man denken wrde. Und vom _anderen_ Punkt aus gemessen */
    #local av = <0, rand(RR) * lyz * 2 - lyz, rand(RR) * lyz * 2 - lyz>;
    #local ev = <0, rand(RR) * lyz * 2 - lyz, rand(RR) * lyz * 2 - lyz>;

    sphere_sweep {
      cubic_spline 4


      (av + wind) 0.03
      <0, 0, 0> 0.03
      endpunkt 0.03
      (endpunkt + ev + 3 * wind) 0.03
      texture {helmetTexture}
    }
  #end
#end



#macro PlayerHaare(wind)
union {
  #if (playerDamaged)
    #local hk = 3;
  #else
    #local hk = 1;
  #end
  
  #local ii = 0;
  #while (ii < haare_anz)
  
    /* Wir bauen uns eine Gleichverteilung auf der Kugel:
       Nutze, dass die Kugelrandflche einer Scheibe der Dicke
       epsilon konstant ist. D. h. whle erst zufllig die y-Koord und dann
       einen Winkel fr Drehung um y-Achse */
    #local y_koord = rand(RR) * (2 - 2*epsi) - (1 - epsi);
    #local drehung = rand(RR) * 360;
      
    #if((y_koord < 0.05) | (y_koord > 0.55) | (drehung < 55) | (drehung > 125))

      #local haar_drehung = transform {
	// Haar so drehen, dass der Endpunkt an der angegebenen y-Koord ist:
	#rotate (asin(y_koord) * 360 / 2 / 3.14159) * z
	// Um die senkrechte Achse drehen
	#rotate drehung * y
      };
      
      #local d_wind = vinv_transform(wind, haar_drehung);
  
      object {
	/* Haarlnge zw. 1 und 1.3 */
	haar(1 + rand(RR)*0.3, hk, d_wind)
        transform {haar_drehung}
      }
    
    #end
    
    #local ii = ii + 1;
  #end
}
#end


#declare augengroesse = 0.2;

#macro Auge(richtung)
union {
  intersection {
    sphere {<0, 0, 0>, 1.3}
    plane {-z, 0}
    texture {faceTexture}
  }
  sphere {<0, 0, 0>, 1
    pigment {White * 1.1}
    finish {Shiny}
  }
  intersection {
    sphere {<0, 0, 0>, 1+epsi}
    sphere {<0, 0, -1>, 0.5}
    #if (playerDamaged)
      pigment {White / 2}
    #else
      pigment {Black}
    #end
    finish {Shiny}
    rotate richtung
  }


  scale augengroesse

  
//  texture {eyeTexture}
}
#end


#declare augpos1 = <-0.3, 0.3, -0.8>;
#declare augpos2 = < 0.3, 0.3, -0.8>;

#macro Augen(ri1, ri2)
  union {
    object { Auge(ri1) translate augpos1 }
    object { Auge(ri2) translate augpos2 }
  }
#end


#declare PlayerAugen = object {
  #if (playerDamaged)
    Augen(<-15, 30, 0>, <35, 5, 0>)
  #else
    Augen(<-5, 0, 0>, <-5, 0, 0>)
  #end
}


#declare Guckbereich = cone {
  <0, 0, 0>, augengroesse
  <0, 0, -1>, 2 * augengroesse
}


/* Der Bereich, der aus den Haaren geschnitten werden muss,
   damit der Wusel was sieht. */
#declare Guckbereiche = union {
  object {Guckbereich translate augpos1}
  object {Guckbereich translate augpos2}
}


union {
  #local body_drehung = transform {
    //rotate 30*x // Damit er in die Kamera schaut; spter auskommentieren
    rotate bodyAngle
  };

  #local d_wind = vinv_transform(FrontWind, body_drehung);
  

  
  //sphere{<0,0,0> 0.1 pigment {color Yellow}}
  
  PlayerHaare(d_wind)

  object {PlayerAugen}
  
  transform {body_drehung}



  translate y*playerHeight
  rotate playerAngle
  translate playerLocation
}
